using UnityEngine;
using UnityEditor;
using System;
using System.IO;
using System.Reflection;

public class MapToolsWLTLayout
{
    public static void LoadLayout(string resourceFileName)
    {
        TextAsset layoutAsset = Resources.Load<TextAsset>(resourceFileName);
        if (layoutAsset == null)
        {
            Debug.LogError("Layout file not found in Resources: " + resourceFileName);
            return;
        }
        
        string tempPath = Path.Combine(Application.temporaryCachePath, resourceFileName + ".wlt");
        try
        {
            File.WriteAllBytes(tempPath, layoutAsset.bytes);
        }
        catch (Exception ex)
        {
            Debug.LogError("Error writing temporary file: " + ex);
            return;
        }

        Type windowLayoutType = typeof(Editor).Assembly.GetType("UnityEditor.WindowLayout");
        if (windowLayoutType == null)
        {
            Debug.LogError("UnityEditor.WindowLayout type not found");
            return;
        }

        MethodInfo loadMethod = windowLayoutType.GetMethod("LoadWindowLayout",
            BindingFlags.Public | BindingFlags.NonPublic | BindingFlags.Static,
            null,
            new Type[] { typeof(string), typeof(bool) },
            null);
        if (loadMethod == null)
        {
            Debug.LogError("LoadWindowLayout method not found");
            return;
        }
        
        try
        {
            loadMethod.Invoke(null, new object[] { tempPath, false });
        }
        catch (Exception ex)
        {
            Debug.LogError("Error loading layout: " + ex);
        }
    }
}